/********************* (C) COPYRIGHT 2010 e-Design Co.,Ltd. ********************
 File Name : main.c  
 Version   : DS203_SYS Ver 1.5x                                  Author : bure
*******************************************************************************/
#include "Function.h"
#include "USB_lib.h"
#include "Config.h"
#include "Ident.h"
#include "BIOS.h"
#include "LCD.h"
#include "ASM.h"
#include "USB_pwr.h"

typedef  void (*pFunc)(void);

pFunc Jump_To_App;
u32 JumpAddr;

/*******************************************************************************
  汾޸˵
SYS V1.24: ޸144MHzģʽµĲֵϵ(BIOS.c)
           ޸V2.6Ӳ·ģ̵λ(BIOS.c)
SYS V1.30: LicenceʶתƵDFUģ(ASM.s,Ident.c)
           ޸LicenceȨ޿(Main.c, Ident.c)
           ޸DFU,SYS⺯÷ʽ(ASM.s, VECTOR.c)
           µSYS⺯(BIOS.c)
SYS V1.31: ڲU̵ĳʼƳٵLicenceʶ(Main.c,Config.c)
           ޸Uд(SPI_flash.c)
           ޸SYS⺯ʼַ
SYS V1.32: ޸Set(T_BASE_ARR, Value)еBUG(BIOS.c)
SYS V1.33: ˶LCDоƬILI9327R61509VļݺԶʶ(LCD.c, ASM.s)
SYS V1.34: Ӹð汾 ɲʹ IAR 4.42룵.汾뻷(ASM.s)
SYS V1.35: ޸LCDоƬصBUG(ASM.s)         
           豸ӲSYS̼DFU汾Ϣ(ASM.s, BIOS.c, Main.c)
           ˸߾ȵA,Bֱͨƫùܺ(BIOS.c)
SYS V1.37: ޸˸߾ȵA,BֱͨƫùܺBUG(BIOS.c)        
           FPGA2.60ϰ汾İ汾Ϣ(BIOS.c)
SYS V1.40: Uļϵͳдغ(DOSFS.c)        
SYS V1.41: ޸˶BUFļʱBUG(DOSFS.c)
SYS V1.42: Row_Fill(ASM.s)
SYS V1.50: дµFAT12ļϵͳ(FAT12.c, ASM.s)
           ޸FlashдܿPCĶдͻ(Memory.c, EXT_Flash.c) 
*******************************************************************************/

uc8  SYS_Ver[5]  = "1.50"; 

/*******************************************************************************
  main : Main routine.
*******************************************************************************/
int main(void)
{ 
  u32 Licence;
  u8  NumStr[9];
  
  Set_System();
  NVIC_Config();
  GPIO_Config();
  Timer_Config();
  FSMC_Config();
  SPI_Config();

  DMA_Config();
  ADC_Config();
  DAC_Config();
  
  Beep(20, 500); 
  LCD_Initial();
  Clear_Screen(0x0000);

  Display_Logo(70,150); 
  
  Display_Str( 5*8, 90, GRN, PRN,  "Hardware Ver " );
  Display_Str(18*8, 90, GRN, PRN,  (u8*)Get(HDWVER, 0));
  Display_Str(25*8, 90, GRN, PRN, "Serial No: ");
  Word2Hex(NumStr, __Dev_SN());            
  Display_Str(36*8, 90, YEL, PRN, NumStr);      // ʾȡ豸к

  Display_Str( 6*8, 70, GRN, PRN, "     DS203 Mini DSO SYS Ver            ");
  Display_Str(34*8, 70, GRN, PRN, (u8*)Get(SYSVER, 0)); // ʾSYS̼汾
  
  if((KEY2_OFF)&&(KEY3_OFF)&&(KEY4_OFF)){       // ް
    Key_Buffer = 0;                             // ״̬ʼȴµİ
    Licence = Get_Lic(SYS_LIC_OFFSET);          // Get master licence
    if(__Chk_SYS(Licence)!= 1){                 // No master licence 
      Display_Str(6*8,50,GRN,PRN,     "Please input master licence: 00000000");
      Licence = Input_Lic(48+29*8, 50);         // Input Licence
      if(__Chk_SYS(Licence)!= 1){               // Licence error
        Display_Str(6*8,50,YEL,PRN,   "        Licence input error          ");
      } else {                                  // Licence ok
        if(Add_Lic(Licence, SYS_LIC_OFFSET)== 1)// Licence writen ok
          Display_Str(6*8,50,GRN,PRN, "         Licence writen ok           ");
        else  
          Display_Str(6*8,50,GRN,PRN, "        Licence writen error         ");
      }
      Display_Str(6*8,30,GRN,PRN,     "      Push any key to next step      ");
      while (Key_Buffer == 0){};
    }
    JumpAddr = *(vu32*) (APP1_BASE + 4);
    Jump_To_App = (pFunc) JumpAddr;
    __MSR_MSP(*(vu32*) APP1_BASE);
  } else if(KEY2_ON){                           // K2  
    JumpAddr = *(vu32*) (APP2_BASE + 4);
    Jump_To_App = (pFunc) JumpAddr;
    __MSR_MSP(*(vu32*) APP2_BASE);
  } else if(KEY3_ON){                           // K3 
    JumpAddr = *(vu32*) (APP3_BASE + 4);
    Jump_To_App = (pFunc) JumpAddr;
    __MSR_MSP(*(vu32*) APP3_BASE);
  } else if(KEY4_ON){                           // K4 
    JumpAddr = *(vu32*) (APP4_BASE + 4);
    Jump_To_App = (pFunc) JumpAddr;
    __MSR_MSP(*(vu32*) APP4_BASE);
  }
  USB_EN();
  USB_Init();  
  Jump_To_App();
}
/*********************************  END OF FILE  ******************************/
